<?php
use yii\helpers\Url;

return [
    [
        'class' => 'kartik\grid\CheckboxColumn',
        'width' => '20px',
    ],
    [
        'class' => 'kartik\grid\SerialColumn',
        'width' => '30px',
    ],
        // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'id',
    // ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'username',
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'email',
    ],
    /*[
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'password_hash',
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'auth_key',
    ],*/
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'last_activity',
    ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'password_reset_token',
    // ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'status',
        'contentOptions' => ['class' => 'text-left', 'style' => 'min-width:100px;'],
        'value' => function ($model) {
            if($model->status == 0){
                return 'Not Comfirmed';
            } elseif($model->status == 1){
                return 'Confirmed';
            } elseif($model->status == 9){
                return 'Inactive';
            } elseif($model->status == 10){
                return 'Active';
            }
        },
        'filterType' => \kartik\grid\GridView::FILTER_SELECT2,
        'filter' => [ // offline, not_valid, key_lock, ad_no, ad_yes
            null => 'All',
            '9' => 'Inactive',
            '10' => 'Active',
            '1' => 'Confirmed',
            '0' => 'Not Comfirmed',
            
        ],
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'groups',
        'label' => 'Groups',
        'value' => function ($model) {
            $_ = $model->groups;
            if($_ == null){
                $a = [];
            }else{
                $a = json_decode($model->groups);
            }
            
            $b = '';
            $c = ', ';
            for($i = 0; $i < count($a); $i++) {
                if($i == count($a)-1){
                    $c = '';
                }
                $b .= $a[$i] . $c;
            }
            return $b;
        }
    ],// [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'repair_token',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'updated_at',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'created_at',
    // ],
    [
        'class' => 'kartik\grid\ActionColumn',
        'dropdown' => false,
        'vAlign'=>'middle',
        'template' => '{update} {delete}',
        'urlCreator' => function($action, $model, $key, $index) { 
                return Url::to([$action,'id'=>$key]);
        },
        'updateOptions'=>['role'=>'modal-remote','title'=>'Update'],
        /*'deleteOptions'=>['role'=>'modal-remote','title'=>'Delete', 
                          'data-confirm'=>false, 'data-method'=>false,// for overide yii data api
                          'data-request-method'=>'post',
                          'data-confirm-title'=>'Are you sure?',
                          'data-confirm-message'=>'Are you sure want to delete this item'],*/ 
    ],

];   